package pushyasm

import (
	"sync"
)

var Reg *registry

func init() {
	Reg = &registry{}
}

type registry struct {
	mu      sync.RWMutex
	metrics []Metric
}

func (r *registry) Add(m Metric) {
	r.mu.Lock()
	defer r.mu.Unlock()
	r.metrics = append(r.metrics, m)
}

func (r *registry) Get() []Metric {
	r.mu.Lock()
	defer r.mu.Unlock()
	return r.metrics
}
