package serverinfo

import (
	"encoding/json"
	"io/ioutil"
	"os"
	"time"
)

const JSONPath = "/etc/server_info.json"

type Info struct {
	Location string `json:"location"`
	WallePrj string `json:"walle_project"`
	CPUModel string `json:"cpu_model"`
}

type ServerInfo struct {
	Path string
	info *Info
	lm   time.Time
}

func New(path string) *ServerInfo {
	return &ServerInfo{
		Path: path,
	}
}

func NewDefault() *ServerInfo {
	return New(JSONPath)
}

func (s *ServerInfo) Read() (*Info, error) {
	stat, err := os.Stat(s.Path)
	if err != nil {
		return nil, err
	}
	if s.info == nil || s.lm != stat.ModTime() {
		rawData, err := ioutil.ReadFile(s.Path)
		if err != nil {
			return nil, err
		}
		if err := json.Unmarshal(rawData, &s.info); err != nil {
			return nil, err
		}
		s.lm = stat.ModTime()
	}
	return s.info, nil
}
