package serverinfo

import (
	"encoding/json"
	"io/ioutil"
	"os"
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestRead(t *testing.T) {
	var (
		loc = "test"
		si  = New("serverinfo_test.json")
	)
	_, err := si.Read()
	assert.Error(t, err, os.ErrNotExist)

	buf, err := json.Marshal(map[string]string{"location": loc})
	assert.NoError(t, err)
	err = ioutil.WriteFile(si.Path, buf, 0644)
	assert.NoError(t, err)

	info, err := si.Read()
	assert.NoError(t, err)

	assert.Equal(t, info.Location, loc)
}
