#!/bin/bash


DIR=$(dirname $(realpath $0))
ROOT=$DIR/../../../../..

set -xe
ya make -t \
   $ROOT/infra/rsm/nvgpumanager/cmd/nvgpuctl \
   $ROOT/infra/rsm/nvgpumanager/cmd/nvgpu-manager \
   $ROOT/infra/environments/rtc-xenial-gpu/release/vm-image

tmp=$(mktemp -d)
cp -L $ROOT/infra/rsm/nvgpumanager/cmd/nvgpuctl/nvgpuctl $tmp
cp -L $ROOT/infra/rsm/nvgpumanager/cmd/nvgpu-manager/nvgpu-manager $tmp

set +e

ya tool vmexec -- \
   -I $ROOT/infra/environments/rtc-xenial-gpu/release/vm-image/rootfs.img \
   -v $tmp:/BUILD \
   --qemu-opts \
"-device secondary-vga,addr=05.0 \
 -device secondary-vga,addr=06.0 \
 -device virtio-gpu-pci,addr=07.0 \
 -device virtio-gpu-pci,addr=08.0 \
 -machine q35,accel=kvm,kernel-irqchip=split \
 -device intel-iommu,intremap=on" \
   --trap \
   -w /BUILD

rm -rf $tmp
