#!/bin/bash


DIR=$(dirname $(realpath $0))
ARCADIA_ROOT=$DIR/../../../../..
PRESTABLE_GROUP="W@yp-iss-prestable-yt-hahn-gpu"

sky list $PRESTABLE_GROUP | sort -R | tail -n 3 > prestable_hosts.txt

set -xe
ya make -t \
   $ARCADIA_ROOT/infra/rsm/nvgpumanager/cmd/nvgpuctl \
   $ARCADIA_ROOT/infra/rsm/nvgpumanager/cmd/nvgpu-manager

${ARCADIA_ROOT}/ya package \
	       --debian \
	       --not-sign-debian \
	       --custom-version=0.2-ci \
	       ${ARCADIA_ROOT}/infra/rsm/nvgpumanager/build/packages/yandex-nvgpu-manager/pkg.json

tmp=$(mktemp -d)
chmod +r $tmp
tar -zxvf yandex-nvgpu-manager.0.2-ci.tar.gz  -C $tmp  yandex-nvgpu-manager_0.2-ci_amd64.deb 

for h in $(cat prestable_hosts.txt | grep -v \#)
do
    scp $tmp/yandex-nvgpu-manager_0.2-ci_amd64.deb $h:/tmp
done
sky run --hosts=prestable_hosts.txt "sudo dpkg -i /tmp/yandex-nvgpu-manager_0.2-ci_amd64.deb"
sky run --hosts=prestable_hosts.txt "systemctl is-active yandex-nvgpu-manager"
sky run --hosts=prestable_hosts.txt 'sudo nvgpuctl list'
rm -rf $tmp
