package main

import (
	"fmt"
	"os"
	"os/exec"
	"path"

	"a.yandex-team.ru/infra/rsm/nvgpumanager/internal/config"
	"a.yandex-team.ru/infra/rsm/nvgpumanager/internal/utils"
	"a.yandex-team.ru/infra/rsm/nvgpumanager/pkg/modprobe"
)

func main() {
	binPath := path.Join(config.DefaultServerRoot, "nvgpu-manager")
	cmd := exec.Command(binPath)
	cmd.Args = append([]string{binPath}, os.Args[1:]...)
	cmd.Stdout = os.Stdout
	cmd.Stderr = os.Stderr

	// TODO: somehow check if nvmlEnabled or vfioEnabled
	err := modprobe.LoadModuleIfUnloaded("nvidia")
	if err != nil {
		fmt.Fprintf(os.Stderr, "Failed to load 'nvidia' kernel module (but try to move on anyway), err: %v\n", err)
	} else {
		// FIXME: This is crunch for https://st.yandex-team.ru/RESMAN-49
		// I need to make github.com/NVIDIA/gpu-monitoring-tools/bindings/go/nvml to work with
		// different nvml lib versions, for this reason I need to set LD_PLIBRARY_PATH before nvml.Init()
		// Unfortunetly os.Setenv() is noop because we build w/o cgo,
		// So the only option is create wrapper which prepare environments and then execute real binary.
		libPath, err := utils.GetNvidiaLibraryPath()
		if err != nil {
			fmt.Fprintf(os.Stderr, "Fail to get lib path: %v\n", err)
			os.Exit(1)
		}

		cmd.Env = append(os.Environ(), "LD_LIBRARY_PATH="+libPath)
	}

	if err := cmd.Start(); err != nil {
		fmt.Fprintf(os.Stderr, "Exec failed: %v\n", err)
		os.Exit(1)
	}
	if err := cmd.Wait(); err != nil {
		if exitErr, ok := err.(*exec.ExitError); ok {
			os.Exit(exitErr.ExitCode())
		}
		os.Exit(1)
	}
}
