package cmd

import (
	"encoding/json"
	"errors"
	"os"

	"github.com/spf13/cobra"

	pb "a.yandex-team.ru/infra/rsm/nvgpumanager/api"
)

// setDriverCmd represents the setDriver command
var setDriverCmd = &cobra.Command{
	Use:   "set-driver",
	Short: "Set device driver",
	RunE: func(cmd *cobra.Command, args []string) error {
		return doSetDriver(cmd, args)
	},
}
var (
	driver string
)

func init() {
	rootCmd.AddCommand(setDriverCmd)
	setDriverCmd.Flags().StringVar(&driver, "driver", "host", "Set driver type, available choice [host, vfio]")
	setDriverCmd.Flags().BoolVarP(&dumpJSON, "json", "J", false, "Json output format")

}

func doSetDriver(cmd *cobra.Command, args []string) error {
	req := &pb.SetDriverRequest{}

	switch driver {
	case "host":
		req.DriverName = "host"
	case "vfio":
		req.DriverName = "vfio"
	default:
		return errors.New("unsupporder driver type: " + driver)
	}

	if len(args) == 0 {
		return errors.New("not enouth arguments")
	}
	// TODO handle ALL alias here
	devList := args

	req.DeviceId = devList

	reply, err := apiClient.Client.SetDriver(apiCtx, req)
	if err != nil {
		return err
	}
	if dumpJSON {
		enc := json.NewEncoder(os.Stdout)
		enc.SetIndent("", "\t")
		return enc.Encode(reply)
	}
	return nil
}
