package client

import (
	"context"

	grpc_opentracing "github.com/grpc-ecosystem/go-grpc-middleware/tracing/opentracing"
	"go.uber.org/zap"
	"google.golang.org/grpc"
	_ "google.golang.org/grpc/metadata"

	pb "a.yandex-team.ru/infra/rsm/nvgpumanager/api"
)

type Client struct {
	Client pb.NvGpuManagerClient
	Log    *zap.Logger
	conn   *grpc.ClientConn
	ctx    context.Context
}

func NewClient(l *zap.Logger, ep string) (*Client, error) {
	l.Debug("NewClient", zap.Any("endpoint", ep))
	// FIXME: add x-client-id metadata
	conn, err := grpc.Dial(ep, grpc.WithInsecure(),
		grpc.WithUnaryInterceptor(grpc_opentracing.UnaryClientInterceptor()),
		grpc.WithStreamInterceptor(grpc_opentracing.StreamClientInterceptor()),
	)
	if err != nil {
		l.Fatal("fail to conect", zap.Error(err))
		return nil, err
	}
	cl := &Client{
		conn:   conn,
		Log:    l,
		Client: pb.NewNvGpuManagerClient(conn),
	}
	return cl, nil
}

// Ping return true if service ping was successful
func (dc *Client) Ping(ctx context.Context) bool {
	_, err := dc.Client.Ping(ctx, &pb.Empty{})

	return err == nil
}

func (dc *Client) Close() {
	if dc != nil {
		err := dc.conn.Close()
		if err != nil {
			dc.Log.Error("close failed", zap.Error(err))
		}
	}
}
