package config

import "time"

const (
	DefaultNvmlMode               = true
	DefaultNvidiaPersistenced     = true
	DefaultNvidiaFabricmanager    = False
	DefaultNvidiaDCGM             = False
	DefaultPeriodicHungTest       = False
	DefaultNvidiaUvm              = True
	DefaultPeerMem                = false
	DefaultIbMetrics              = false
	DefaultAllocIbDevs            = false
	DefaultAllocIncludeIbUverbs   = true
	DefaultAllocIncludeRoceUverbs = true
	DefaultAllocNvgpuUnixSocket   = false
	DefaultEnableSocketActivation = false
	DefaultEnableLimitsFixup      = true
	DefaultVfioMode               = Optional
	DefaultForceVfioInit          = false
	DefaultMockMode               = MockDisabled
	DefaultSecureMode             = true

	DefaultServerAddress    = "unix:/run/yandex-nvgpu-manager.sock"
	DefaultServerLock       = "/run/yandex-nvgpu-manager.lock"
	DefaultSockPermissions  = 0o664
	DefaultSockOwner        = 0
	DefaultSockGroup        = 1334
	DefaultServerConf       = "/etc/nvgpu-manager.yaml"
	DefaultServerLog        = "/var/log/yandex-nvgpu-manager.log"
	DefaultServerRoot       = "/opt/nvgpu-manager2"
	DefaultServerLayers     = DefaultServerRoot + "/layers"
	DefaultCUDALayer        = DefaultServerLayers + "/libcuda"
	DefaultYasmProdURL      = "http://localhost:11005"
	DefaultYasmProdCType    = "prod"
	DefaultYasmPRodProj     = "nvgpu-manager"
	DefaultYasmTestURL      = "http://localhost:100229"
	DefaultYasmPushPeriod   = 5
	DefaultDCGMSocketAddr   = "localhost"
	DefaultDCGMIsUnixSocket = false

	NvidiaPersistencedServiceName = "/opt/yandex-nvidia-utils/bin/nvidia-persistenced"
	NvidiaPersistencedPidFilePath = "/var/run/nvidia-persistenced/nvidia-persistenced.pid"

	NvidiaFabricmanagerServiceName = "/opt/yandex-nvidia-utils/bin/nv-fabricmanager"
	NvidiaFabricmanagerPidFilePath = "/var/run/nvidia-fabricmanager/nv-fabricmanager.pid"

	NvidiaDCGMServiceName = "/usr/bin/nv-hostengine"
	NvidiaDCGMPidFilePath = "/var/run/nvhostengine.pid"

	PeriodicHungTestBinName = "cuda-check"
	PeriodicHungTestPeriod  = 30 * time.Minute
	PeriodicHungTestTimeout = 25 * time.Minute

	A100_80FreqMax = 1200 // MHz
	A100_80FreqMin = 1200 // MHz

	A100_80Power = 430 * 1000 // mW

	StuckGPUUtil  = 100 // %
	StuckGPUPower = 100 // W
	StuckGPUTemp  = 40  // C
	StuckGPUTime  = 35  // min
)

const (
	MockDisabled      = "disabled"
	MockNoMig         = "no-mig"
	MockDcgmNoMig     = "no-mig-dcgm"
	MockOneMig        = "one-mig"
	MockDcgmOneMig    = "one-mig-dcgm"
	MockTwoMigSameGpu = "two-mig-same-gpu"
	MockTwoMigDiffGpu = "two-mig-diff-gpu"
)

var (
	NvidiaPersistencedDefaultArgs  = []string{"--user", "nvidia-persistenced", "--persistence-mode", "--verbose"}
	NvidiaFabricmanagerDefaultArgs = []string{"-c", "/etc/nvidia-fabricmanager.cfg"}
	NvidiaDCGMDefaultArgs          = []string{}
	PeriodicHungTestBinDefaultArgs = []string{"--test_dev_sync"}
)
