package device

import (
	"a.yandex-team.ru/infra/rsm/nvgpumanager/internal/config"
	"fmt"
)

type DcgmMock struct {
	results map[string]DcgmValues
}

func generateStatuses() map[string]DcgmValues {
	return map[string]DcgmValues{
		"GPU-b6c54489-38a0-5f50-a60a-fd8d76219cae": DcgmValues{
			SmUtilization: 0.551,
			SmOccupancy:   0.381,
		},
		"GPU-11116e73-1c03-5de6-9130-5f9925ae8ab4": DcgmValues{
			SmUtilization: 0.992,
			SmOccupancy:   0.960,
		},
		"MIG-GPU-b6c54489-38a0-5f50-a60a-fd8d76219cae/5/0": DcgmValues{
			SmUtilization: 0.101,
			SmOccupancy:   0.223,
		},
	}
}

func NewDcgmMock(mockMode string) DcgmInterface {
	switch mockMode {
	case config.MockDcgmNoMig, config.MockDcgmOneMig:
		return &DcgmMock{results: generateStatuses()}
	default:
		return nil
	}
}

func (dcgmLib *DcgmMock) Init(c *config.Configuration) error { return nil }

func (dcgmLib *DcgmMock) Shutdown() error { return nil }

func (dcgmLib *DcgmMock) UpdateDevices() error { return nil }

func (dcgmLib *DcgmMock) UpdateValues() error { return nil }

func (dcgmLib *DcgmMock) GetDeviceValues(dev NvmlAPIDevice) (*DcgmValues, error) {
	stat, ok := dcgmLib.results[dev.GetUUID()]
	if !ok {
		return nil, fmt.Errorf("can't found device status with uuid %s", dev.GetUUID())
	}
	return &stat, nil
}
