package device

import "a.yandex-team.ru/infra/rsm/nvgpumanager/vendor/github.com/NVIDIA/go-nvml/pkg/nvml"

type NvComputeInstance struct {
	ComputeInstance nvml.ComputeInstance
	InstanceID      uint32
	InstanceMinor   uint32
	Path            string
	// InstaceInfo
}

type NvGpuInstance struct {
	GpuInstance   nvml.GpuInstance
	InstanceID    uint32
	InstanceMinor uint32
	Path          string
	// InstanceInfo
	ComputeInstances map[uint32]*NvComputeInstance
}

type FullNvmlAPIDevice struct {
	Device       nvml.Device
	UUID         string
	Minor        uint32
	Path         string
	Model        string
	Power        uint32
	Memory       uint64
	CPUAffinity  uint
	PCIBusID     string // nvml.PciInfo
	MigMode      bool
	GpuInstances map[uint32]*NvGpuInstance
	MigDevices   []*MigNvmlAPIDevice
	// Clocks                ClockInfo
	// Topology              []P2PLink
	// CudaComputeCapability CudaComputeCapabilityInfo
}

func (dev *FullNvmlAPIDevice) GetDevice() nvml.Device {
	return dev.Device
}

func (dev *FullNvmlAPIDevice) GetUUID() string {
	return dev.UUID
}

func (dev *FullNvmlAPIDevice) GetModel() string {
	return dev.Model
}

func (dev *FullNvmlAPIDevice) GetPathes() []string {
	return []string{dev.Path}
}

func (dev *FullNvmlAPIDevice) GetUniquePath() string {
	return dev.Path
}

func (dev *FullNvmlAPIDevice) GetPower() uint32 {
	return dev.Power
}

func (dev *FullNvmlAPIDevice) GetMemory() uint64 {
	return dev.Memory
}

func (dev *FullNvmlAPIDevice) GetCPUAffinity() uint {
	return dev.CPUAffinity
}

func (dev *FullNvmlAPIDevice) GetPCIBusID() string {
	return dev.PCIBusID
}

func (dev *FullNvmlAPIDevice) IsMigEnabled() bool {
	return dev.MigMode
}

func (dev *FullNvmlAPIDevice) IsMigDevice() bool {
	return false
}

func (dev *FullNvmlAPIDevice) GetMigDevices() []*MigNvmlAPIDevice {
	return dev.MigDevices
}

func (dev *FullNvmlAPIDevice) GetMinor() uint32 {
	return dev.Minor
}
