package device

import (
	"errors"
	"io/ioutil"
	"strings"

	"github.com/gofrs/uuid"
	"go.uber.org/zap"

	"a.yandex-team.ru/infra/rsm/nvgpumanager/internal/ilog"
)

var (
	machineID   string
	machineUUID uuid.UUID
)

func getMachineID(mpath string) (string, error) {
	data, err := ioutil.ReadFile(mpath)
	if err != nil {
		return "", err
	}
	s := string(data)
	if idx := strings.IndexRune(s, '\n'); idx != -1 {
		s = s[:idx]
	}
	mid := strings.TrimSpace(s)
	if len(mid) < 10 {
		return "", errors.New("Bad machine_id got: " + machineID)
	}
	return mid, nil
}

// init machinId variable
func init() {
	data, err := ioutil.ReadFile("/etc/machine-id")
	if err != nil {
		panic("Fail to open /etc/machine_id, err:" + err.Error())
	}
	s := string(data)
	if idx := strings.IndexRune(s, '\n'); idx != -1 {
		s = s[:idx]
	}
	machineID = strings.TrimSpace(s)
	if len(machineID) < 10 {
		panic("Bad machine_id got: " + machineID)
	}
	machineUUID = uuid.NewV5(uuid.NamespaceDNS, machineID+".machine.yandex.team.ru")
}

func HWNamespace() uuid.UUID {
	return machineUUID
}

func MockHWNamespace() {
	machineUUID = uuid.NewV5(uuid.NamespaceDNS, "xtest.machine.yandex.team.ru")
	ilog.Log().Info("Enable Mock HWNamespace mode",
		zap.String("uuid", machineUUID.String()))
}
