package device

import (
	"testing"

	"github.com/gofrs/uuid"
	"github.com/stretchr/testify/require"
)

func TestMachineId(t *testing.T) {
	ns := uuid.NewV5(uuid.NamespaceDNS, "xtest.machine.yandex.team.ru")

	dev := &PciDevice{
		BusID:        "0000:03:00.0",
		Vendor:       "10de",
		Device:       "1023",
		SubSysVendor: "097e",
		SubSysDevice: "10de",
		ModelName:    "GK110BGL [Tesla K40m]",
		Driver:       "",
		NumaNode:     0,
	}
	dev.GenUUIDWithNamespace(ns)
	require.Equal(t, "82707dc7-0e5b-5b8b-8080-b9f19e01201e", dev.UUID)
}
