package device

import "a.yandex-team.ru/infra/rsm/nvgpumanager/vendor/github.com/NVIDIA/go-nvml/pkg/nvml"

type MigNvmlAPIDevice struct {
	Device          nvml.Device
	ParentDevice    *FullNvmlAPIDevice `json:"-"` // to avoid zap's json encoder error about reference cycle
	GpuInstance     *NvGpuInstance
	ComputeInstance *NvComputeInstance
	UUID            string
	Model           string
	Power           uint32
	Memory          uint64
}

func (dev *MigNvmlAPIDevice) GetDevice() nvml.Device {
	return dev.Device
}

func (dev *MigNvmlAPIDevice) GetUUID() string {
	return dev.UUID
}

func (dev *MigNvmlAPIDevice) GetModel() string {
	return dev.Model
}

func (dev *MigNvmlAPIDevice) GetPathes() []string {
	return []string{dev.ParentDevice.Path, dev.GpuInstance.Path, dev.ComputeInstance.Path}
}

func (dev *MigNvmlAPIDevice) GetUniquePath() string {
	return dev.ComputeInstance.Path
}

func (dev *MigNvmlAPIDevice) GetPower() uint32 {
	return dev.Power
}

func (dev *MigNvmlAPIDevice) GetMemory() uint64 {
	return dev.Memory
}

func (dev *MigNvmlAPIDevice) GetCPUAffinity() uint {
	return dev.ParentDevice.CPUAffinity
}

func (dev *MigNvmlAPIDevice) GetPCIBusID() string {
	return dev.ParentDevice.PCIBusID
}

func (dev *MigNvmlAPIDevice) IsMigDevice() bool {
	return true
}

func (dev *MigNvmlAPIDevice) IsMigEnabled() bool {
	return false
}

func (dev *MigNvmlAPIDevice) GetMinor() uint32 {
	return dev.ComputeInstance.InstanceMinor
}
