package device

import "path"

type PciLibNvidia struct{}
type PciLibQemuMock struct{}

var (
	PciGpuClass = map[string]string{
		"030000": "VGA compatible controller",
		"030200": "3D controller",
	}
	PciQemuMockClass = map[string]string{
		"030000": "VGA compatible controller",
		"038000": "Display controller",
	}
)

func (pl *PciLibNvidia) NewPciDev(busID string) (*PciDevice, error) {
	// Request only nvidia devices
	return newPciDev(path.Join("/sys/bus/pci/devices", busID))
}

func (pl *PciLibNvidia) NewPciDevices() ([]*PciDevice, error) {
	// Request only nvidia devices
	return newPciDevices("/sys/bus/pci/devices", "10de", PciGpuClass)
}

func (pl *PciLibQemuMock) NewPciDev(busID string) (*PciDevice, error) {
	// Request only nvidia devices
	return newPciDev(path.Join("/sys/bus/pci/devices", busID))
}

func (pl *PciLibQemuMock) NewPciDevices() ([]*PciDevice, error) {
	// Request only qemu virtual vga devices
	return newPciDevices("/sys/bus/pci/devices", "1234", PciQemuMockClass)
}
