package pciids_test

import (
	"testing"

	"github.com/stretchr/testify/require"

	"a.yandex-team.ru/infra/rsm/nvgpumanager/internal/pciids"
)

func TestCheckDB(t *testing.T) {
	var tests = []struct {
		vendor     string
		vendorName string
		device     string
		deviceName string
	}{
		{"10de", "NVIDIA Corporation", "1b80", "gpu_tesla_k40"},
		{"10de", "NVIDIA Corporation", "1b06", "gpu_geforce_1080ti"},
		{"10de", "NVIDIA Corporation", "1024", "gpu_tesla_k40"},
		{"10de", "NVIDIA Corporation", "1023", "gpu_tesla_k40"},
		{"10de", "NVIDIA Corporation", "17fd", "gpu_tesla_m40"},
		{"10de", "NVIDIA Corporation", "1b38", "gpu_tesla_p40"},
		{"10de", "NVIDIA Corporation", "1db4", "gpu_tesla_v100"},
		{"10de", "NVIDIA Corporation", "1db6", "gpu_tesla_v100"},
		{"10de", "NVIDIA Corporation", "20b0", "gpu_tesla_a100"},
		{"10de", "NVIDIA Corporation", "20b2", "gpu_tesla_a100_80g"},
		{"1234", "Red Hat", "1111", "virt_gpu"},
		{"1af4", "Red Hat", "1110", "virtio_vm_shmem"},
	}
	m := pciids.NewIDs()
	for _, tt := range tests {
		t.Run(tt.vendor+"."+tt.device, func(t *testing.T) {
			vendor, ok := m[tt.vendor]
			require.True(t, ok)
			require.Equal(t, tt.vendorName, vendor.Name)
			device, ok := vendor.Devices[tt.device]
			require.True(t, ok)
			require.Equal(t, tt.deviceName, device.Name)
		})
	}
}
