package pciids

type Device struct {
	Chip     string
	Name     string
	MemoryGb uint32
}

type Vendor struct {
	Name    string
	Devices map[string]Device
}

func NewIDs() map[string]Vendor {
	return map[string]Vendor{
		"10de": Vendor{
			Name:    "NVIDIA Corporation",
			Devices: nvidiaDevices,
		},
		"1234": Vendor{
			Name:    "Red Hat",
			Devices: qemuDevices,
		},
		"1af4": Vendor{
			Name:    "Red Hat",
			Devices: virtioDevices,
		},
	}
}
