package utils

import (
	opentracing "github.com/opentracing/opentracing-go"
	"github.com/opentracing/opentracing-go/ext"
	"github.com/opentracing/opentracing-go/log"
)

// SpanLogError add error event info for the span
func SpanLogError(span opentracing.Span, err error) {
	ext.Error.Set(span, true)
	span.LogFields(log.String("event", "error"), log.String("message", err.Error()))
}

// SpanCheckError error event info for the span if error is not nil
func SpanCheckError(span opentracing.Span, err error) {
	if err == nil {
		return
	}
	SpanLogError(span, err)
}
