package utils_test

import (
	"testing"

	"github.com/stretchr/testify/require"

	"a.yandex-team.ru/infra/rsm/nvgpumanager/internal/utils"
)

func TestParseProcDev(t *testing.T) {
	testProcDevData := `Character devices:
  1 mem
  4 /dev/vc/0
  4 tty
  4 ttyS
  5 /dev/tty
  5 /dev/console
  5 /dev/ptmx
  5 ttyprintk
  7 vcs
 10 misc
 13 input
 21 sg
 29 fb
128 ptm
136 pts
180 usb
189 usb_device
202 cpu/msr
203 cpu/cpuid
226 drm
243 vfio
244 ipmidev
245 hidraw
246 nvme
247 bsg
248 watchdog
249 ptp
250 pps
251 rtc
252 dax
253 tpm
254 gpiochip

Block devices:
  7 loop
  8 sd
  9 md
 11 sr
 43 nbd
 65 sd
 66 sd
 67 sd
 68 sd
 69 sd
 70 sd
 71 sd
128 sd
129 sd
130 sd
131 sd
132 sd
133 sd
134 sd
135 sd
252 device-mapper
253 virtblk
254 mdp
259 blkext`

	referenceDevMap := map[string]int{
		"mem":           1,
		"/dev/vc/0":     4,
		"tty":           4,
		"ttyS":          4,
		"/dev/tty":      5,
		"/dev/console":  5,
		"/dev/ptmx":     5,
		"ttyprintk":     5,
		"vcs":           7,
		"misc":          10,
		"input":         13,
		"sg":            21,
		"fb":            29,
		"ptm":           128,
		"pts":           136,
		"usb":           180,
		"usb_device":    189,
		"cpu/msr":       202,
		"cpu/cpuid":     203,
		"drm":           226,
		"vfio":          243,
		"ipmidev":       244,
		"hidraw":        245,
		"nvme":          246,
		"bsg":           247,
		"watchdog":      248,
		"ptp":           249,
		"pps":           250,
		"rtc":           251,
		"dax":           252,
		"tpm":           253,
		"gpiochip":      254,
		"loop":          7,
		"md":            9,
		"sr":            11,
		"nbd":           43,
		"sd":            135,
		"device-mapper": 252,
		"virtblk":       253,
		"mdp":           254,
		"blkext":        259,
	}

	parsedDevMap := utils.ParseProcDev(testProcDevData)

	require.Equal(t, referenceDevMap, parsedDevMap)
}
