package utils

import (
	"time"

	pb "a.yandex-team.ru/infra/rsm/nvgpumanager/api"
	"github.com/golang/protobuf/ptypes/timestamp"
)

func TimeFormatPB(t time.Time) *timestamp.Timestamp {
	return &timestamp.Timestamp{Seconds: t.Unix(), Nanos: int32(t.Nanosecond())}
}

func SetCondition(c *pb.Condition, status bool, msg string) {
	c.Status = status
	c.Message = msg
	c.LastTransitionTime = TimeFormatPB(time.Now())
}

func CopyCondition(to *pb.Condition, from *pb.Condition) {
	to.Status = from.Status
	to.Message = from.Message
	to.LastTransitionTime = from.LastTransitionTime
}

func UpdateCondidion(c *pb.Condition, status bool, msg string) {
	if c.Status != status {
		SetCondition(c, status, msg)
	}
}
