package utils

import (
	"fmt"
	"reflect"
)

func applyField(T interface{}, fName string, value interface{}) error {

	type TaskInfo struct {
		Obj    reflect.Value
		FName  string
		FValue reflect.Value
	}

	queue := []TaskInfo{TaskInfo{reflect.ValueOf(T).Elem(), fName, reflect.ValueOf(value)}}

	for len(queue) != 0 {
		info := queue[0]
		queue = queue[1:]

		objType := info.Obj.Type()
		valType := info.FValue.Type()
		valKind := valType.Kind()

		fieldType, ok := objType.FieldByName(info.FName)
		if !ok {
			return fmt.Errorf("no field with name %s", info.FName)
		}
		fieldKind := fieldType.Type.Kind()

		field := info.Obj.FieldByName(info.FName)

		if valKind == reflect.Map && fieldKind == reflect.Struct {
			iter := info.FValue.MapRange()

			for iter.Next() {
				queue = append(queue, TaskInfo{field, iter.Key().String(), iter.Value().Elem()})
			}

			continue
		}

		// There is a great field for work: add support for lists, map, structur's pointers

		if !field.CanSet() {
			return fmt.Errorf("field %s cann't be set", info.FName)
		}

		if !info.FValue.CanConvert(fieldType.Type) {
			return fmt.Errorf("cann't convert %s value to %s for field %s", valType, fieldType.Type, info.FName)
		}

		field.Set(info.FValue.Convert(fieldType.Type))
	}
	return nil
}

func GenerateObjects[T any](defaultObject T, changes []map[string]interface{}) ([]T, error) {

	res := []T{}

	for _, val := range changes {
		res = append(res, defaultObject) // need for deeeeeeep copy
		baseObj := &res[len(res)-1]
		for k, v := range val {
			err := applyField(baseObj, k, v)
			if err != nil {
				return nil, err
			}
		}
	}
	return res, nil
}
