package yasm

import (
	"time"
)

const (
	TssMaxDepth = 10
)

type Int64Sample struct {
	Val int64
	TS  time.Time
}

type Int64TSS struct {
	sample [TssMaxDepth]Int64Sample
}

// InitAt set object with initialized value
func (v *Int64TSS) InitAt(new int64, ts time.Time) {
	v.sample[0].Val = new
	v.sample[0].TS = ts

	for i := 1; i < TssMaxDepth; i++ {
		v.sample[i] = v.sample[0]
	}
}

// Init return new object with initialized value
func (v *Int64TSS) Init(new int64) {
	v.InitAt(new, time.Now())
}

// UpdateAt set new  value with explicit time stamp
func (v *Int64TSS) UpdateAt(new int64, ts time.Time) {
	v.sample[0].Val = new
	v.sample[0].TS = ts

	for i := TssMaxDepth - 1; i >= 1; i-- {
		delta := time.Second << i
		if v.sample[i].TS.Before(ts.Add(-delta)) {
			v.sample[i] = v.sample[i-1]
		}
	}
}

// Update set new  value with valrent time stamp
func (v *Int64TSS) Update(new int64) {
	v.UpdateAt(new, time.Now())
}

// Cur return valrent value
func (v *Int64TSS) Cur() int64 {
	return v.sample[0].Val
}

// DiffPS returns trend per second since last update
func (v *Int64TSS) DiffPS() int64 {
	diff := v.sample[0].Val - v.sample[TssMaxDepth-1].Val
	since := v.sample[0].TS.Sub(v.sample[TssMaxDepth-1].TS) / time.Second
	if since != 0 {
		return diff / int64(since)
	}
	return 0

}
