#!/bin/bash

set -xe
cd $(dirname $0)

# Fetch fresh pci.ids
tdir=$(mktemp -d)
curl -o $tdir/pci.ids https://raw.githubusercontent.com/pciutils/pciids/master/pci.ids

cat $tdir/pci.ids | \
    grep -A10000  "10de  NVIDIA Corporation" |\
    grep -B10000 "10df  Emulex Corporation"|\
    head -n-1 > $tdir/nvidia-pci.ids

cat $tdir/pci.ids | \
    grep -A10000  "1af4  Red Hat, Inc." |\
    grep -B10000 "1af5  Netezza Corp."|\
    head -n-1 > $tdir/redhat-pci.ids

# Convert it to goobject
ya tool go get -v -u github.com/bensallen/pciids/cmd/pciids2go
cat $tdir/*-pci.ids > $tdir/pci-filtered.ids
pciids2go -i $tdir/pci-filtered.ids -o ../internal/pciids/pciids.go -t go
