#!/bin/bash

# parsing args
while getopts ":b:s:" opt; do
	case $opt in
		b) cuda_check_bin="$OPTARG"
		;;
		s) sleep_interval="$OPTARG"
		;;
		\?) echo "Invalid option '-$OPTARG'" >&2
		exit 1
		;;
	esac

	case $OPTARG in
		-*) echo "Option '$opt' needs a valid argument."
		exit 1
		;;
	esac
done

# default values
sleep_interval=${sleep_interval:-10m}

if [ -z "$cuda_check_bin" ]
then
	cuda_check_bin=`which cuda-check`
	if [ $? -ne 0 ]
	then
		echo "No cuda-check binary found."
		exit 1
	fi

	cuda_check_bin=`echo $cuda_check_bin | gawk '{print $1}'`
fi

# run loop
while true
do
	$cuda_check_bin --test_dev_sync -T 10m

	echo
	echo "started sleeping for $sleep_interval..."
	sleep $sleep_interval
done
