#!/bin/bash

set -xe

PKG_URL="https://developer.download.nvidia.com/compute/cuda/repos/ubuntu1804/x86_64"
PKG_LIST="nvidia-utils libnvidia-compute libnvidia-cfg1 nvidia-compute-utils"

# kver=${1:-450.80.02}
kver=${1:-470.129.06}
sfx=${2:-"-0ubuntu1_amd64"}


tdir=$(mktemp -d nvidia_pkgXXXX)
pushd $tdir
for p in $PKG_LIST
do
    major=$(echo $kver| cut -d. -f1)
    fname=$p-${major}_$kver$sfx.deb
    curl -JO $PKG_URL/$fname
    dpkg-deb -x $fname $p-$kver
done

for p in "nvidia-fabricmanager"
do
    major=$(echo $kver| cut -d. -f1)
    fname=$p-${major}_$kver-1_amd64.deb
    curl -JO $PKG_URL/$fname
    dpkg-deb -x $fname $p-$kver
done


popd

mkdir $tdir/$kver
cp $tdir/libnvidia-compute-$kver/usr/lib/x86_64-linux-gnu/libnvidia-ml.so.$kver $tdir/$kver/libnvidia-ml.so.1
cp $tdir/libnvidia-cfg1-$kver/usr/lib/x86_64-linux-gnu/libnvidia-cfg.so.$kver $tdir/$kver/libnvidia-cfg.so.1
cp $tdir/nvidia-utils-$kver/usr/bin/nvidia-smi $tdir/$kver/
cp $tdir/nvidia-utils-$kver/usr/bin/nvidia-bug-report.sh $tdir/$kver/
cp $tdir/nvidia-compute-utils-$kver/usr/bin/nvidia-persistenced $tdir/$kver/

mkdir $tdir/$kver/topology
cp $tdir/nvidia-fabricmanager-$kver/usr/bin/nv-fabricmanager $tdir/$kver/
cp $tdir/nvidia-fabricmanager-$kver/usr/share/nvidia/nvswitch/fabricmanager.cfg $tdir/$kver/nvidia-fabricmanager.cfg
cp $tdir/nvidia-fabricmanager-$kver/usr/share/nvidia/nvswitch/dgx2_hgx2_topology $tdir/$kver/topology/
cp $tdir/nvidia-fabricmanager-$kver/usr/share/nvidia/nvswitch/dgxa100_hgxa100_topology $tdir/$kver/topology/
sed -i 's/ABORT_CUDA_JOBS_ON_FM_EXIT=1/ABORT_CUDA_JOBS_ON_FM_EXIT=0/g' $tdir/$kver/nvidia-fabricmanager.cfg
sed -i 's/TOPOLOGY_FILE_PATH=\/usr\/share\/nvidia\/nvswitch/TOPOLOGY_FILE_PATH=\/opt\/yandex-nvidia-utils\/'$kver'\/topology\//g' $tdir/$kver/nvidia-fabricmanager.cfg

ya upload --tar --ttl=inf -A generator=infra/rsm/nvgpumanager/tools/nvidia-utils-wrapper/upload_bundle.sh \
   -A nvidia_driver_version=$kver \
   $tdir/$kver

rm -rf $tdir
