package main

import (
	"context"
	"os"

	"go.uber.org/zap"

	"a.yandex-team.ru/infra/rsm/nvgpumanager/internal/device"
	"a.yandex-team.ru/infra/rsm/nvgpumanager/internal/ilog"
	"a.yandex-team.ru/infra/rsm/nvgpumanager/pkg/modprobe"
)

func init() {
	err := modprobe.LoadModule("vfio-pci")
	assertNoErr(err)
}

func assertNoErr(err error) {
	if err != nil {
		panic("Error found: " + err.Error())
	}
}

func main() {
	driver := "vfio-pci"
	if len(os.Args) > 1 {
		driver = os.Args[1]
	}
	ctx, cancel := context.WithCancel(context.Background())
	defer cancel()

	//// Switch all QemuMock devices to vfio-pci mode
	api := device.PciLibQemuMock{}
	devices, err := api.NewPciDevices()
	assertNoErr(err)

	for _, d := range devices {
		ilog.Log().Info("set driver for", zap.String("id", d.UUID))
		grp, err := d.SetDriver(ctx, driver)
		ilog.Log().Info("set driver", zap.String("id", d.UUID), zap.Any("group", grp),
			zap.Error(err))
		assertNoErr(err)
	}
}
