package cpuid

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestParse(t *testing.T) {
	var (
		tests = []struct {
			actual   []byte
			expected *CPUID
			err      bool
		}{
			{
				[]byte("cpu:type:x86,ven0000fam0006mod0055:feature:"),
				&CPUID{
					Arch:   "x86",
					Vendor: "intel",
					Family: 6,
					Model:  85,
					MArch:  "skylake",
				},
				false,
			},
		}
	)

	for _, test := range tests {
		cpuid, err := parse(test.actual)
		if test.err {
			assert.Error(t, err)
		} else {
			assert.NoError(t, err)
		}
		assert.Equal(t, test.expected, cpuid)
	}
}
