package perf

import (
	"bytes"
	"context"
	"os/exec"
	"syscall"
	"time"
)

func cmdRun(ctx context.Context, tt, tk time.Duration, skipErr bool, pth string, args ...string) (stdout *bytes.Buffer, stderr *bytes.Buffer, err error) {
	waitDone := make(chan struct{})
	defer close(waitDone)
	stdout = new(bytes.Buffer)
	stderr = new(bytes.Buffer)
	cmd := exec.Command(pth, args...)
	cmd.Stdout = stdout
	cmd.Stderr = stderr

	err = cmd.Start()
	if err != nil {
		return
	}
	go func() {
		for {
			select {
			case <-time.After(tt):
				_ = cmd.Process.Signal(syscall.SIGTERM)
			case <-time.After(tk):
				_ = cmd.Process.Kill()
			case <-ctx.Done():
				_ = cmd.Process.Kill()
			case <-waitDone:
				return
			}
		}
	}()

	err = cmd.Wait()
	if err != nil && skipErr {
		err = nil
	}
	return
}

func min(x, y int) int {
	if x > y {
		return y
	}
	return x
}
