package podsinfo

import (
	"fmt"
	"time"
)

type Pod struct {
	Name           string // name of nanny service or pod_set_id
	CgName         string // cgroup name like porto%ISS-AGENT--21587
	CtName         string // container name like ISS-AGENT--21587
	statNameToStat map[string]*Stat
}

func NewPod(n string) *Pod {
	pod := &Pod{
		CgName:         CgrpPrfxPorto + n,
		CtName:         n,
		statNameToStat: map[string]*Stat{},
	}
	for k, v := range StatNameToFunc {
		pod.statNameToStat[k] = NewStat(v)
	}
	return pod
}

func (p *Pod) updateStats(ts time.Time, data map[string]string) (err error) {
	var stat *Stat
	for n, s := range data {
		if stat = p.statNameToStat[n]; stat == nil {
			return fmt.Errorf("undefined stat name: %s", n)
		}
		if err = stat.UpdateFromStr(ts, s); err != nil {
			return err
		}
	}
	return
}

func (p *Pod) GetNetRxBytes() uint64 {
	return p.getStatByName(StatNameNetRxBytes).GetPerSec()
}

func (p *Pod) GetNetTxBytes() uint64 {
	return p.getStatByName(StatNameNetTxBytes).GetPerSec()
}

func (p *Pod) GetNetRxPkts() uint64 {
	return p.getStatByName(StatNameNetRxPkts).GetPerSec()
}

func (p *Pod) GetNetTxPkts() uint64 {
	return p.getStatByName(StatNameNetTxPkts).GetPerSec()
}

func (p *Pod) GetIOReadBytes() uint64 {
	return p.getStatByName(StatNameIOReadBytes).GetPerSec()
}

func (p *Pod) GetIOWriteBytes() uint64 {
	return p.getStatByName(StatNameIOWriteBytes).GetPerSec()
}

func (p *Pod) GetCPUUsage() uint64 {
	return p.getStatByName(StatNameCPUUsage).GetAbs()
}

func (p *Pod) getStatByName(n string) (s *Stat) {
	s = p.statNameToStat[n]
	if s == nil {
		return &Stat{}
	}
	return
}
