package podsinfo

import (
	"testing"
	"time"

	"github.com/stretchr/testify/assert"
)

func TestStatUpdateFromStr(t *testing.T) {
	var (
		ts    = time.Now()
		tests = []struct {
			s              string
			stat           *Stat
			expectedLast   uint64
			expectedPerSec uint64
		}{
			{
				"Latency: 3434; Uplink: 10; group default: 884785375486312; ip6tnl0: 0; veth: 884785375486312",
				&Stat{
					pf: ParseNet,
					b: [2]*Backet{
						&Backet{},
						&Backet{ts.Add(-StatCacheTimeout * 2), 5},
					},
				},
				10,
				0,
			},
			{
				"bla-bla: 12; hw: 6 ; sda: 35062034997248; sdb: 35348836864000",
				&Stat{
					pf: ParseIO,
					b: [2]*Backet{
						&Backet{},
						&Backet{ts.Add(-time.Second), 2},
					},
				},
				6,
				4,
			},
			{
				" 1750334174 ",
				NewStat(ParseUint),
				1750334174,
				0,
			},
		}
	)
	for _, test := range tests {
		err := test.stat.UpdateFromStr(ts, test.s)
		assert.NoError(t, err)
		assert.Equal(t, test.stat.b[1].ts, ts)
		assert.Equal(t, test.expectedLast, test.stat.GetAbs())
		assert.Equal(t, test.expectedPerSec, test.stat.GetPerSec())
	}
}
