
import os
import datetime
import nirvana.job_context as nv
from infra.rtc.analytics.utils.utils import DATE_FORMAT

PROJECT_MR_DIRECTORY_MAPPING = {
    "USER_TOP": "//home/runtimecloud/research/KERNEL-691/user_top/{0}",
    "TMA": "//home/runtimecloud/research/KERNEL-691/stat-log/{0}",
    "TMA_AGGREGATES": "//home/runtimecloud/research/KERNEL-691/stat_log_views/{0}",
    "USER_TOP_WITHOUT_CPU": "//home/runtimecloud/research/KERNEL-691/user_top/{0}_without_cpu",
    "CPUUSAGE_HOURLY_AGGREGATES": "//home/runtimecloud/research/KERNEL-691/cpuusage_per_hour/{0}",
    "CPUUSAGE_HOURLY_AGGREGATES_SERVICES": "//home/runtimecloud/research/KERNEL-691/cpuusage_per_hour/{0}_services"
}


if __name__ == '__main__':

    job_context = nv.context()
    outputs = job_context.get_outputs()

    data_type = os.environ.get("DATA_TYPE")
    filename = os.environ.get("OUTPUT_FILE")

    date_string = PROJECT_MR_DIRECTORY_MAPPING[data_type].format((datetime.datetime.today().date() -
                                                                  datetime.timedelta(days=1)).strftime(DATE_FORMAT))

    with open(outputs.get(filename), "w") as write_file:
        write_file.write(date_string)
