import nirvana.job_context as nv
import requests
import os
import datetime
import time
from infra.rtc.analytics.utils.utils import DATE_FORMAT


def get_partition_name(part_format):
    last_week = (datetime.datetime.today() - datetime.timedelta(days=8)).strftime(part_format)
    return last_week


tma_partition_format = "%Y%m%d"
user_top_partition_format = "%Y-%m-%d"
user_top_query = '''ALTER TABLE perfmanager.user_top DELETE where parseDateTime32BestEffort(date) < date_sub(DAY, 7, parseDateTime32BestEffort('{0}'))'''.format(datetime.datetime.today().strftime(DATE_FORMAT))
tma_cpu_query = '''ALTER TABLE perfmanager.tma_aggregates_cpu_model DELETE where dt < {0}'''.format(str(int((datetime.datetime.today() -
                                                                                                           datetime.timedelta(days=7)).timestamp())))
user_top_query_cpu = '''
ALTER TABLE perfmanager.user_top_cpu DROP PARTITION '{0}'
'''.format(get_partition_name(user_top_partition_format))

avg_cpuusage_query = '''ALTER TABLE perfmanager.cpuusage_hourly_aggregates DELETE where ts < {0}'''.format(int(datetime.datetime.now().timestamp()) - 60 * 60 * 24 * 7)
avg_cpuusage_query_services = '''ALTER TABLE perfmanager.cpuusage_hourly_aggregates_services DELETE where ts < {0}'''.format(int(datetime.datetime.now().timestamp()) - 60 * 60 * 24 * 7)

queries = [
    user_top_query, tma_cpu_query, user_top_query_cpu, avg_cpuusage_query, avg_cpuusage_query_services
]


if __name__ == '__main__':
    job_context = nv.context()

    os.system("wget https://crls.yandex.net/YandexInternalRootCA.crt")
    time.sleep(5)
    base_url = 'https://sas-hkr9ewrebhcqfmnj.db.yandex.net:8443/?database=perfmanager&query={0}'
    auth = {
        'X-ClickHouse-User': 'perfmanager',
        'X-ClickHouse-Key': os.environ.get("PERFMANAGER_PASSWORD"),
    }

    cert_path = "YandexInternalRootCA.crt"

    for query in queries:
        rs = requests.post(base_url.format(query), headers=auth, verify=cert_path)
        rs.raise_for_status()
