
import datetime
import yt.wrapper
from infra.rtc.rtc_billing.utils import PrepareBillingData


DEFAULT_ABC_SERVICE = "UNKNOWN"


def get_table_name(table=None, table_timestamp=None):
    yt.wrapper.config.set_proxy("hahn")

    if table:
        return table

    base_path = "//home/data_com/cubes/gencfg/groups_data"

    if table_timestamp:
        table_name = "/".join([base_path, datetime.datetime.fromtimestamp(table_timestamp).strftime("%Y-%m-%d")])
    else:
        table_name = "/".join([base_path, datetime.datetime.today().strftime("%Y-%m-%d")])

    if (yt.wrapper.exists(table_name) and not PrepareBillingData.check_table_with_data(table_name)) \
            or not yt.wrapper.exists(table_name):
        table_name = "/".join([base_path,
                               (datetime.datetime.today() - datetime.timedelta(days=1)).strftime("%Y-%m-%d")])

        if (yt.wrapper.exists(table_name) and not PrepareBillingData.check_table_with_data(table_name)) \
                or not yt.wrapper.exists(table_name):
            table_name = "/".join([base_path,
                                   (datetime.datetime.today() - datetime.timedelta(days=2)).strftime(
                                       "%Y-%m-%d")])
            if (yt.wrapper.exists(table_name) and not PrepareBillingData.check_table_with_data(table_name)) \
                    or not yt.wrapper.exists(table_name):
                table_name = "/".join([base_path,
                                       (datetime.datetime.today() - datetime.timedelta(days=3)).strftime(
                                           "%Y-%m-%d")])
                if not PrepareBillingData.check_table_with_data(table_name):
                    raise Exception("Yesterday table {0} is empty".format(table_name))

    return table_name


def split_chunks(lst, chnksize):

    for i in range(0, len(lst), chnksize):
        yield lst[i:i + chnksize]


def extract_top_parents(service_name, parents):
    if len(parents) >= 2:
        return parents[-1], parents[-2]
    elif len(parents) == 1:
        return parents[0], service_name
    else:
        return service_name, service_name


def extract_gencfg_group_itag_position(itags):
    for i in range(len(itags)):
        if itags[i][0].upper() == itags[i][0]:
            return i

    return None


def clean_abc_id(abc_id):
    return abc_id.replace("abc:service:", "")
