package cmd

import (
	"context"
	"fmt"
	"github.com/spf13/cobra"
	"os"
	"strings"

	"a.yandex-team.ru/infra/rsm/nvgpumanager/pkg/juggler"
	"a.yandex-team.ru/infra/rsm/sysconf/internal/plugin"
)

var (
	jr = juggler.JugglerRequest{
		Source: "sysconf",
		Events: []juggler.JugglerEvent{
			juggler.JugglerEvent{
				Description: "0",
				Service:     "sysconf",
				Status:      "OK",
			},
		},
	}
	checkCmd = &cobra.Command{
		Use:   "check",
		Short: "Validate plugin",
		Run:   func(cmd *cobra.Command, args []string) { check() },
	}
)

type state map[string]int

func (s state) Inc(p string) {
	if _, ok := s[p]; !ok {
		s[p] = 0
	}
	s[p]++
}

func (s state) String() string {
	b := &strings.Builder{}
	for k, v := range s {
		fmt.Fprintf(b, "%s:%d ", k, v)
	}
	return b.String()
}

func init() { rootCmd.AddCommand(checkCmd) }

func check() {
	crit := state{}
	j := juggler.NewJugglerClient()
	for _, p := range plugin.List() {
		err := p.IsApplicable()
		fmt.Printf("%s: %s\n", p.Name(), err.Status)
		if err.Status == plugin.StatusFail {
			fmt.Println(err.Err)
		}
		if err.Status != plugin.StatusEnable {
			continue
		}
		for _, err := range p.Check() {
			fmt.Println("", err.String())
			if err.Status == plugin.StatusFail || err.Status == plugin.StatusDiff {
				crit.Inc(p.Name())
			}
		}
	}
	if len(crit) != 0 {
		jr.Events[0].Description = crit.String()
		jr.Events[0].Status = "CRIT"
	}
	if err := j.PushEvents(context.TODO(), jr); err != nil {
		fmt.Println(err)
		os.Exit(1)
	}
}
