package cmd

import (
	"github.com/spf13/cobra"

	"a.yandex-team.ru/infra/rsm/sysconf/internal/plugin"
	"fmt"
)

var enableCmd = &cobra.Command{
	Use:   "enable",
	Short: "Enable plugin",
	Run: func(cmd *cobra.Command, args []string) {
		pname := args[0]
		p, ok := plugin.GetByName(pname)
		if !ok {
			fmt.Printf("%s plugin doesn't exiist\n", pname)
			return
		}
		err := p.IsApplicable()
		fmt.Printf("%s: %s\n", p.Name(), err.Status)
		if err.Status != plugin.StatusEnable {
			fmt.Println(err.Err)
			return
		}
		for _, err := range p.Enable(force) {
			fmt.Println("", err.String())
		}
	},
}

func init() { rootCmd.AddCommand(enableCmd) }
