package cmd

import (
	"github.com/spf13/cobra"

	"a.yandex-team.ru/infra/rsm/sysconf/internal/plugin"
	"fmt"
)

var listCmd = &cobra.Command{
	Use:   "list",
	Short: "List available plugins",
	Run: func(cmd *cobra.Command, args []string) {
		for _, p := range plugin.List() {
			fmt.Printf("%15s - %s\n", p.Name(), p.Doc())
		}
	},
}

func init() { rootCmd.AddCommand(listCmd) }
