package cmd

import (
	"fmt"
	"github.com/spf13/cobra"
	"os"

	"a.yandex-team.ru/library/go/core/buildinfo"
)

var (
	force   bool
	rootCmd = &cobra.Command{
		Use:   "sysconf",
		Short: "sysconf",
		Long: `SYSconf,
      Wiki: https://wiki.yandex-team.ru/rtcnetdev/sysconf
      Docs: https://a.yandex-team.ru/arc/trunk/arcadia/infra/sysconf/README.md`,
		Version: buildinfo.Info.ProgramVersion,
	}
)

func init() {
	if buildinfo.Info.ProgramVersion == "" {
		rootCmd.Version = "N/A"
	} else {
		rootCmd.Version = buildinfo.Info.ProgramVersion
	}
	rootCmd.PersistentFlags().BoolVar(&force, "force", false, "force run")
}

func Execute() {
	if err := rootCmd.Execute(); err != nil {
		fmt.Println(err)
		os.Exit(1)
	}
}
