package internal

import (
	"bytes"
	"fmt"
	"io/ioutil"
	"os"
)

func IsFileExists(filename string) error {
	_, err := os.Stat(filename)
	return err
}

func IsFileContent(pth string, ptrn string) error {
	data, err := ioutil.ReadFile(pth)
	if err != nil {
		return err
	}
	if !bytes.Equal(bytes.TrimSpace(data[:]), []byte(ptrn)) {
		return fmt.Errorf("%s doesn't content %s", pth, ptrn)
	}
	return nil
}

func IsNotFileContent(pth string, ptrn string) error {
	data, err := ioutil.ReadFile(pth)
	if err != nil {
		return err
	}
	if bytes.Equal(bytes.TrimSpace(data[:]), []byte(ptrn)) {
		return fmt.Errorf("%s content %s", pth, ptrn)
	}
	return nil
}
