package example

import (
	"a.yandex-team.ru/infra/rsm/sysconf/internal"
	"a.yandex-team.ru/infra/rsm/sysconf/internal/plugin"
)

type pl struct{}

func init() {
	plugin.Register(&pl{})
}

func (p *pl) Name() string {
	return "example"
}

func (p *pl) Doc() string {
	return "https://st.yandex-team.ru/TICKET-NUMBER"
}

func (p *pl) IsApplicable() (st plugin.State) {
	st.Status = plugin.StatusEnable
	if st.Err = internal.IsFileContent("/path/to/file", "NeedSuperFeature"); st.Err != nil {
		st.Status = plugin.StatusSkip
	}
	return
}

func (p *pl) Check() (sts plugin.States) {
	sts.Add(checkSuperFeature())
	return
}

func (p *pl) Enable(force bool) (sts plugin.States) {
	var st plugin.State
	if !force {
		sts.Add(plugin.State{Name: "self", Status: plugin.StatusSkip, Err: plugin.ErrNeedForce})
	}
	if st = checkSuperFeature(); st.Status == plugin.StatusDiff {
		st = enableSuperFeature()
	}
	sts.Add(st)
	return
}

func (p *pl) Disable(force bool) (sts plugin.States) {
	sts.Add(plugin.State{Name: "self", Status: plugin.StatusSkip, Err: plugin.ErrNotImpl})
	return
}

func enableSuperFeature() (st plugin.State) {
	st = plugin.State{Name: "super", Status: plugin.StatusOk, Err: nil}
	// apply something
	return
}

func checkSuperFeature() (st plugin.State) {
	st = plugin.State{Name: "super", Status: plugin.StatusOk, Err: nil}
	// check something
	return
}
