package netlimit

import (
	"testing"

	"github.com/stretchr/testify/require"
	"github.com/vishvananda/netlink"
)

func TestFiltersEqual(t *testing.T) {
	la := netlink.NewLinkAttrs()
	la.Name = "test"
	l := &netlink.Dummy{LinkAttrs: la}

	f1, err := NewU32Filter(l, netlink.MakeHandle(0x0, 0x0), 10, "2a02:6b8:fc01::/48", netlink.TC_ACT_OK)
	require.NoError(t, err)
	f2, err := NewU32Filter(l, netlink.MakeHandle(0x0, 0x0), 10, "2a02:6b8:fc01::/48", netlink.TC_ACT_OK)
	require.NoError(t, err)

	f3, err := NewU32Filter(l, netlink.MakeHandle(0x0, 0x0), 10, "2a02:6b8:fc01::/48", netlink.TC_ACT_OK)
	require.NoError(t, err)
	f4, err := NewU32Filter(l, netlink.MakeHandle(0x0, 0x0), 10, "2a02:6b8:fc01::/48", netlink.TC_ACT_JUMP)
	require.NoError(t, err)

	f5, err := NewU32Filter(l, netlink.MakeHandle(0x0, 0x0), 10, "2a02:6b8:fc01::/36", netlink.TC_ACT_OK)
	require.NoError(t, err)
	f6, err := NewU32Filter(l, netlink.MakeHandle(0x0, 0x0), 10, "2a02:6b8:fc01::/48", netlink.TC_ACT_OK)
	require.NoError(t, err)

	f7, err := NewU32Filter(l, netlink.MakeHandle(0x0, 0x0), 10, "2a02:6b8:fc01::/48", netlink.TC_ACT_OK)
	require.NoError(t, err)
	require.NoError(t, SetU32Police(f7, 100000000, 0, 1250000, 65536, netlink.TC_ACT_SHOT))
	f8, err := NewU32Filter(l, netlink.MakeHandle(0x0, 0x0), 10, "2a02:6b8:fc01::/48", netlink.TC_ACT_OK)
	require.NoError(t, err)
	require.NoError(t, SetU32Police(f8, 100000000, 0, 1250000, 65536, netlink.TC_ACT_OK))

	f9, err := NewU32Filter(l, netlink.MakeHandle(0x0, 0x0), 10, "2a02:6b8:fc01::/48", netlink.TC_ACT_OK)
	require.NoError(t, err)
	require.NoError(t, SetU32Police(f9, 100000000, 0, 1250000, 65536, netlink.TC_ACT_OK))
	f10, err := NewU32Filter(l, netlink.MakeHandle(0x0, 0x0), 10, "2a02:6b8:fc01::/48", netlink.TC_ACT_OK)
	require.NoError(t, err)
	require.NoError(t, SetU32Police(f10, 100000000, 0, 1250000, 65535, netlink.TC_ACT_OK))

	f11, err := NewU32Filter(l, netlink.MakeHandle(0x0, 0x0), 10, "2a02:6b8:fc01::/48", netlink.TC_ACT_OK)
	require.NoError(t, err)
	require.NoError(t, SetU32Police(f11, 100000000, 0, 1250000, 65536, netlink.TC_ACT_OK))
	f12, err := NewU32Filter(l, netlink.MakeHandle(0x0, 0x0), 10, "2a02:6b8:fc01::/48", netlink.TC_ACT_OK)
	require.NoError(t, err)
	require.NoError(t, SetU32Police(f12, 100000000, 0, 12500, 65536, netlink.TC_ACT_OK))

	f13, err := NewU32Filter(l, netlink.MakeHandle(0x0, 0x0), 10, "2a02:6b8:fc01::/48", netlink.TC_ACT_OK)
	require.NoError(t, err)
	require.NoError(t, SetU32Police(f13, 100000000, 0, 1250000, 65536, netlink.TC_ACT_OK))
	f14, err := NewU32Filter(l, netlink.MakeHandle(0x0, 0x0), 10, "2a02:6b8:fc01::/48", netlink.TC_ACT_OK)
	require.NoError(t, err)
	require.NoError(t, SetU32Police(f14, 100000, 0, 1250000, 65536, netlink.TC_ACT_OK))

	tests := []struct {
		ef netlink.Filter
		f  netlink.Filter
		e  bool
	}{
		{
			ef: &U32{},
			f:  &U32{},
			e:  false,
		}, {
			ef: f1,
			f:  f2,
			e:  false,
		}, {
			ef: f3,
			f:  f4,
			e:  true,
		}, {
			ef: f5,
			f:  f6,
			e:  true,
		}, {
			ef: f7,
			f:  f8,
			e:  true,
		}, {
			ef: f9,
			f:  f10,
			e:  true,
		}, {
			ef: f11,
			f:  f12,
			e:  true,
		}, {
			ef: f13,
			f:  f14,
			e:  true,
		},
	}

	for _, tt := range tests {
		if tt.e == true {
			require.Error(t, filtersEqual([]netlink.Filter{tt.ef}, []netlink.Filter{tt.f}))
		} else {
			require.NoError(t, filtersEqual([]netlink.Filter{tt.ef}, []netlink.Filter{tt.f}))
		}
	}
}
