package sysinfo

import (
	"os"
	"strings"
	"syscall"
	"time"
)

func Uptime() (time.Duration, error) {
	si := &syscall.Sysinfo_t{}
	if err := syscall.Sysinfo(si); err != nil {
		return 0, err
	}
	return time.Duration(si.Uptime) * time.Second, nil
}

func Hostname() (hostName string, fqdn string, err error) {
	fqdn, err = os.Hostname()
	hostName = strings.Split(fqdn, ".")[0]
	return
}
