package main

import (
	"fmt"
	"os"

	"github.com/gofrs/flock"

	"a.yandex-team.ru/infra/rsm/sysconf/cmd"
	_ "a.yandex-team.ru/infra/rsm/sysconf/internal/plugin/cpufreq"
	_ "a.yandex-team.ru/infra/rsm/sysconf/internal/plugin/irqbalance"
	_ "a.yandex-team.ru/infra/rsm/sysconf/internal/plugin/netlimit"
	_ "a.yandex-team.ru/infra/rsm/sysconf/internal/plugin/rdma"
	_ "a.yandex-team.ru/infra/rsm/sysconf/internal/plugin/rdmaib"
	_ "a.yandex-team.ru/infra/rsm/sysconf/internal/plugin/sched"
	_ "a.yandex-team.ru/infra/rsm/sysconf/internal/plugin/scterc"
	_ "a.yandex-team.ru/infra/rsm/sysconf/internal/plugin/sigbus"
	_ "a.yandex-team.ru/infra/rsm/sysconf/internal/plugin/xpsoff"
)

const lockPath = "/tmp/yandex-sysconf.lock"

func main() {
	fileLock := flock.New(lockPath)
	locked, err := fileLock.TryLock()
	defer fileLock.Unlock()
	if !locked || err != nil {
		fmt.Printf("Failed to lock %s: %s\n", lockPath, err)
		os.Exit(1)
	}
	cmd.Execute()
}
