package fs

import (
	"io/ioutil"
	"os"
	"os/exec"
	"testing"

	"github.com/stretchr/testify/require"
)

func TestClassInfiniband(t *testing.T) {
	var (
		tests = map[string]*PCIDev{
			"mlx5_0": &PCIDev{
				Driver: "mlx5_core",
				Slot:   "0000:47:00.0",
				Class:  "20700",
				Vendor: "15B3",
				Device: "101B",
			},
			"mlx5_1": &PCIDev{
				Driver: "mlx5_core",
				Slot:   "0000:47:00.1",
				Class:  "20000",
				Vendor: "15B3",
				Device: "101B",
			},
		}
	)

	tdir, err := ioutil.TempDir("", "TestClassInfiniband")
	require.NoError(t, err)
	defer os.RemoveAll(tdir)

	err = unpackSysfs(t, tdir)
	require.NoError(t, err)

	devs, err := NewSys(tdir).ClassInfiniband()
	require.NoError(t, err)

	for n, tt := range tests {
		dev, ok := devs[n]
		require.True(t, ok)
		require.Equal(t, tt.Driver, dev.PCI.Driver)
		require.Equal(t, tt.Slot, dev.PCI.Slot)
		require.Equal(t, tt.Class, dev.PCI.Class)
		require.Equal(t, tt.Vendor, dev.PCI.Vendor)
		require.Equal(t, tt.Device, dev.PCI.Device)
	}
}

func unpackSysfs(t *testing.T, dir string) error {
	c := exec.Command("/bin/tar", "-zxf", "testdata/sysfs.tar.gz", "-C", dir)
	c.Stdout = os.Stdout
	c.Stderr = os.Stderr
	return c.Run()
}
