package mlx

import (
	"fmt"
	"os/exec"
	"regexp"
	"strconv"
	"strings"
)

const (
	CmdRegPath   = "/usr/bin/mlxreg"
	regFieldRgxp = `(\w+).+(0x[0-9]+)`
)

type RegData map[string]int

func (rd *RegData) String() string {
	data := []string{}
	for k, v := range *rd {
		data = append(data, fmt.Sprintf("%s=%d", k, v))
	}
	return strings.Join(data, ",")
}

func RegGet(dev, name string) (*RegData, error) {
	return regDo("-d", dev, "--reg_name", name, "--get")
}

func RegSet(dev, name string, rd *RegData) (*RegData, error) {
	return regDo("-d", dev, "--reg_name", name, "--yes", "--set", rd.String())
}

func regDo(args ...string) (*RegData, error) {
	data := RegData{}
	out, err := exec.Command(CmdRegPath, args[:]...).Output()
	if err != nil {
		return nil, err
	}
	rgxp := regexp.MustCompile(regFieldRgxp)
	for _, i := range rgxp.FindAllSubmatch(out, -1) {
		field := string(i[1])
		val, err := strconv.ParseInt(string(i[2]), 0, 64)
		if err != nil {
			return nil, err
		}
		data[field] = int(val)
	}
	return &data, nil
}
