package setpci

import (
	"bytes"
	"fmt"
	"os/exec"
)

const (
	cmdPath = "/usr/bin/setpci"
)

func Get(pci, name string) ([]byte, error) {
	return Do("-s", pci, name)
}

func Set(pci, name, val string) ([]byte, error) {
	return Do("-s", pci, fmt.Sprintf("%s=%s", name, val))
}

func Do(args ...string) ([]byte, error) {
	out, err := exec.Command(cmdPath, args[:]...).Output()
	if err != nil {
		return nil, err
	}
	return bytes.TrimSpace(out), nil
}
