package smartctl

import (
	"fmt"
	"os/exec"
	"regexp"
	"strings"
)

var (
	cmdPath          = "/usr/sbin/smartctl"
	SctErcFieldsRgxp = regexp.MustCompile(`(Read|Write):\s*([0-9]+|Disabled).*`)
)

type SctErcData map[string]string

func SctErcGet(dev string) (SctErcData, error) {
	return makeSctErc("-l", "scterc", fmt.Sprintf("/dev/%s", dev))
}

func SctErcSet(dev string, read, write string) (SctErcData, error) {
	return makeSctErc("-l", fmt.Sprintf("scterc,%s,%s", read, write), fmt.Sprintf("/dev/%s", dev))
}

func makeSctErc(args ...string) (SctErcData, error) {
	data := SctErcData{}
	out, err := exec.Command(cmdPath, args[:]...).Output()
	if err != nil {
		return nil, err
	}
	for _, i := range SctErcFieldsRgxp.FindAllSubmatch(out, -1) {
		field := string(i[1])
		data[field] = strings.Replace(string(i[2]), "Disabled", "0", -1)
	}
	return data, nil
}
