function get_workers()
  local json = require("json")
  local file, err = io.open("dump.json", "r")

  if file == nil then
    return 1
  end

  local porto_properties = json.decode(file:read("*a"));
  io.close(file)

  default_constraint = constraint or "cpu_limit"

  cpu_limit = porto_properties["container"]["constraints"][default_constraint]
  if cpu_limit == nil or cpu_limit == "" then
    error("failed to read cpu_limit from dump.json")
  end
  cpu_limit = tonumber(string.match(cpu_limit, "%d+.%d+"))
  if cpu_limit == nil or cpu_limit <= 0 then
    error("cpu_limit is nil or negative " .. cpu_limit)
  end
  return math.ceil(cpu_limit)
end

return get_workers
