#!/usr/bin/env bash

# Provides: check_balancer_zombie_procs


die () {
    echo "PASSIVE-CHECK:check_balancer_zombie_procs;$1;$2"
    exit 0
}

zproces=$(ps -eo state,pid,cmd | awk '/balancer-[0-9]+/ {if ($1 == "Z") {printf "%s: %s; ",$2,$3}}')
[ -z "${zproces}" ] && die 0 "No zombie processes found"
die 2 "Zombie procs found: ${zproces}"
