#!/usr/bin/env python
# Provides: porto_memory_usage

import porto
import sys


def die(check_name, status, message):
    print 'PASSIVE-CHECK:%s;%s;%s' % (check_name, status, message)
    sys.exit(0)


if __name__ == '__main__':
    check_name = "porto_memory_usage"
    msg = 'RSS over %s percent of mem limit'
    warn_level = 85
    crit_level = 90
    warn_msg = msg % warn_level
    crit_msg = msg % crit_level

    p_api = porto.Connection()
    mem_limit = p_api.GetProperty('self', 'memory_limit_total')
    max_rss = p_api.GetProperty('self', 'max_rss')
    # state = p_api.GetData('self', 'state')

    if mem_limit == '0':
        die(check_name, 0, "Pseudo-OK: memory_limit_total is 0")

    prc = int(max_rss) * 100.0 / int(mem_limit)

    if prc >= crit_level:
        die(check_name, 2, crit_msg)
    elif prc >= warn_level:
        die(check_name, 1, warn_msg)
    else:
        die(check_name, 0, "Ok")
