#!/bin/sh
#
# Provides: push-client
#
# $Id: push_client.sh 11281 2017-07-26 16:52:05Z mixas $
# $HeadURL: svn+ssh://svn.yandex.ru/monitor/trunk/yandex-farm/projects/monitoring/monitoring-only/search/home/monitor/agents/modules-available/push_client.sh $
#
# Some info available on https://st.yandex-team.ru/SEPE-9386

: ${COMMIT_THRESH=$((60*60*24))}
: ${I_PATH_REGEXP='.*'}
: ${I_PATH_IGNORE='^$'}

MSG_CRIT=""
MSG_WARN=""

for i_path in /db/iss3/services/*/active/*; do
    [ -d "$i_path" ] || continue
    echo $i_path | grep -qE "$I_PATH_REGEXP" || continue
    echo $i_path | grep -qE "$I_PATH_IGNORE" && continue

    i_name="$(basename $i_path)"
    BINARY="$i_path/wrap-pushclient-$(echo $i_path | awk -F / '{print $5}')"
    [ -x "$BINARY" ] || BINARY="$i_path/pushclient-$(echo $i_path | awk -F / '{print $5}')"
    [ -x "$BINARY" ] || continue

    CONFIG="$i_path/push-client_real.yml"
    [ -f "$CONFIG" ] || CONFIG="$i_path/push-client_real.conf" # alternative name
    [ -f "$CONFIG" ] || CONFIG="$i_path/push-client.conf" # another alternative name

    EXEC="$BINARY -c $CONFIG --status --json"

    result=$($EXEC 2>&1 || { sleep 20; $EXEC 2>&1; } || { sleep 20; $EXEC 2>&1; }) # try to avoid absent logs (in rotate)
    if [ $? -ne 0 ]; then
        MSG_CRIT="Test push-client for '$i_name' failed; ${MSG_CRIT}"
        if [ -z "$result" ]; then
            MSG_CRIT="Push-client test for '$i_name' returned empty list; ${MSG_CRIT}"
            continue
        fi
    fi

    loaded=$(echo "$result" | jq '.[].name' | wc -l) # also happens if log files are empty. SEPE-14959
    if [ "${loaded}" -lt 1 ]; then
        MSG_WARN="No one file loaded for '$i_name' ${MSG_WARN}"
        continue
    fi

    freshest_commit=$(echo "$result" | jq '.[]["last commit time"] // 0' | sort -n | tail -1)
    if [ -n "${freshest_commit}" ]; then
        [ "$((`date +%s` - $freshest_commit))" -gt "$COMMIT_THRESH" ] && \
            MSG_CRIT="Last commit_time for '$i_name' is more than $COMMIT_THRESH secs; ${MSG_CRIT}";
    else
        MSG_CRIT="No commit_time for '$i_name' for last $COMMIT_THRESH secs; ${MSG_CRIT}";
    fi
done

if [ -n "${MSG_CRIT}" ]; then
    [ -n "${MSG_WARN}" ] && MSG_CRIT="CRITS:: ${MSG_CRIT}WARNS:: ${MSG_WARN}"
    echo "PASSIVE-CHECK:push-client;2;$MSG_CRIT"
elif [ -n "${MSG_WARN}" ]; then
    echo "PASSIVE-CHECK:push-client;1;$MSG_WARN"
else
    echo "PASSIVE-CHECK:push-client;0;Ok"
fi

exit 0
